// StupidRat.cpp starts

/*******************************************************
*	Modified: CGP, 9/17/00.
*		Modified environment API for rat. The rat no longer deals with absolute
* 		positions such as NORTH, SOUTH, EAST, WEST, or CENTER. Instead, the rat
* 		deals with turns relative to his or her current position.
*	Modified: CGP, 12/24/00.
*		Removed usage of explicit messaging calls. The API now conceals these
*		calls and consequently when the rat is taken off the maze, and
*		he calls a perception/action function (see RatPlugin.h), he blocks
*		until the experimenter sends a RATMSG_GO message to the rat.
*	Modified: CGP, 1/09/01
*		Added DebugServer parameter to constructor.
*******************************************************/

#include <OS.h>
#include <stdio.h>
#include <stdlib.h>

#include "StupidRat.h"
#include "Debug.h"
#include "RatEnvMessage.h"
#include "EnvironmentConstants.h"
#include "RatStdLib.h"

/*******************************************************
*   
*******************************************************/
RatPlugin *instantiate_rat(PortMessage *ratPort, DatabaseMessage *dbMsg,
	RatEnvMessage *ratEnvMsg, DebugServer *bugServer) {
   return new StupidRatPlugin(ratPort, dbMsg, ratEnvMsg, bugServer);
}

StupidRatPlugin::StupidRatPlugin(PortMessage *ratPort, DatabaseMessage *dbMsg,
	RatEnvMessage *ratEnvMsg, DebugServer *bugServer)
		: RatPlugin(ratPort, dbMsg, ratEnvMsg, bugServer) {
   initRand();
}

/*******************************************************
*
*******************************************************/
StupidRatPlugin::~StupidRatPlugin(){
}

// This rat movement implementation makes few assumptions about the rats
// current location than ChooseNextArm(). For example, this does not assume
// that the rat is in the center of the maze.
void StupidRatPlugin::MoveRat()
{
	bool moved = false;
	int theSign;
	
	// Determine turn direction
	if (tossCoin()) {
		theSign = +1; // clockwise
	} else {
		theSign = -1; // counter clockwise
	}
	
	// Look around and see if there is a way to move from here.
	while (! moved) {
		// Check if we've got a opening in front of us.
		if (RAT_IsOpen()) {
			if (tossCoin()) { // 0.5 probability to enter
				RAT_Move(); // enter (arm or center)
				moved = true;
				if (RAT_FoodHere()) {
					RAT_EatFood();
					Debug('n', "StupidRatPlugin::ChooseNextArm: Consumed food");
				}
			}
		}
		
		if (! moved) {
			// Rotate a small amount to find opening.
			RAT_Rotate(theSign * (1 + (random() % MIN_ROTATE_ANGLE)));
		}
	}
}

/*******************************************************
* Main function for the rat thread.
*******************************************************/
long StupidRatPlugin::PLUGIN_Start()
{
	Debug('n', "StupidRatPlugin::PLUGIN_Start: In the Stupid Rat Thread!!!");
	
	for (;;) {
		MoveRat();
	}

	return 0;
}

// StupidRat.cpp ends